#!/bin/sh
#
# Retrospect Client Install script
# 6/2008 
# 
# (C) 2014 Retrospect, Inc. Portions (C) 1989-2010 EMC Corporation. All rights reserved.
# www.retrospect.com
# 
#  Get the system architecture
#
ARCH=`uname`
CLIENTDIR=/usr/local/retrospect/client
STATEFILE=/var/log/retroclient.state
EXCLUDEFILE=/etc/retroclient.excludes

ISROOT="Yes"

if [ "$UID" -ne 0 ] || [ ! -d "/usr/local" ] || [ ! -f ./RCL.tar ]; then
    ISROOT="No"
fi

if [ $ISROOT != "Yes" ]; then
    echo
    echo "Sorry, installation requires that you be logged on as root,"
    echo "that a /usr/local directory already exist, and that "
    echo "the RCL.tar archive is in the current directory."
    exit 0
fi

# Set up location for init.d and rc.d

# Default location
INITD=/etc/init.d
RCD=rc.d/

# Red Hat and CentOS locations
if [ -r '/etc/redhat-release' ]; then
	INITD=/etc/rc.d/init.d
	RCD=rc.d/
fi


UPGRADE=""

if [ -x /sbin/pidof ] && [ "$(/sbin/pidof retroclient)" ] || [ "$(ps -e | grep retroclient)" ]; then
    UPGRADE=TRUE
 fi

echo
echo -n "Install Retrospect Client? (y/n): "
read X

if [ "$X" != "y" ] && [ "$X" != "Y" ]; then
	echo "Installation canceled."
	exit 0
fi
if [ $UPGRADE ]; then
	$CLIENTDIR/retrocpl -stop > /dev/null
fi
if [ ! -d "/usr/local/retrospect" ]; then
   /bin/mkdir /usr/local/retrospect
fi
if [ ! -d "$CLIENTDIR" ]; then
   /bin/mkdir $CLIENTDIR 
fi
tar -xf ./RCL.tar
/bin/mv -f ./retroclient ./retrocpl ./retroeventhandler  $CLIENTDIR 
/bin/mv -f ./rcl $INITD
ln -sf $INITD/rcl $CLIENTDIR/rcl 

if [ ! -f $EXCLUDEFILE ]; then
    /bin/mv -f ./retroclient.excludes /etc
else
    /bin/rm -f ./retroclient.excludes
fi
if [ ! -f $STATEFILE ]; then
    $CLIENTDIR/retroclient -setpass
fi

#
# Install man and info pages
#
if [ ! -d "/usr/local/man/man1" ]; then
   /bin/mkdir -p /usr/local/man/man1
fi
/bin/mv -f ./retroclient.1.gz ./retrocpl.1.gz /usr/local/man/man1
if [ -f ./retroclient.1 ]; then
	/bin/mv -f ./retroclient.1 ./retrocpl.1 /usr/local/man/man1
fi
if [ -d "/usr/man/man1" ]; then
	cp -f /usr/local/man/man1/retroclient.* /usr/man/man1
	cp -f /usr/local/man/man1/retrocpl.* /usr/man/man1
fi

if [ ! -d "/usr/share/info" ]; then
   /bin/mkdir -p /usr/share/info
fi
/bin/mv -f ./retroclient.info.gz /usr/share/info
if  [ -L /usr/share/info/dir ]; then
	INFODIRFILE=/etc/info-dir
else
	INFODIRFILE=/usr/share/info/dir
fi
cat<< EOF >> $INFODIRFILE

Retrospect Client 
* retroclient: (retroclient).					Retrospect Client.
* retrocpl: (retroclient)retrocpl.				Retrospect Client Control Panel.
EOF


#
#  Set up the environment variables
#
#  Bash/sh first
echo ""
echo -n "Adding RETROSPECT_HOME to system profile and login scripts..."

if [ -f /etc/profile ]
then
	ISTHERE=`grep RETROSPECT_HOME /etc/profile`
	if [ ! -z "$ISTHERE" ]
	then
		cp /etc/profile /etc/profile.old
		sed -e "/RETROSPECT_HOME/d" < /etc/profile.old > /etc/profile
	fi
	echo "RETROSPECT_HOME=$CLIENTDIR" >> /etc/profile
	echo "export RETROSPECT_HOME" >> /etc/profile
fi
#
#  csh now
#
if [ -f /etc/.login ]
then
	ISTHERE=`grep RETROSPECT_HOME /etc/.login`
	if [ ! -z "$ISTHERE" ]
	then
		cp /etc/.login /etc/.login.old
		sed -e "/RETROSPECT_HOME/d" < /etc/.login.old > /etc/.login
	fi
	echo "setenv RETROSPECT_HOME $CLIENTDIR" >> /etc/.login
fi
echo "Done!"

echo "Starting client as daemon... "
RETROSPECT_HOME="$CLIENTDIR"
export RETROSPECT_HOME
$CLIENTDIR/rcl start
echo

if [ ! -x /sbin/pidof ] && [ "$(/sbin/pidof retroclient)" ] || [ -z "$(ps -e | grep retroclient)" ]; then
   echo "Installation was successful, but Retrospect Client for Linux could not "
    echo "be started. If this is an upgrade, please wait 5 minutes, then start "
    echo "the client manually by running  $ $CLIENTDIR/rcl start"
else
    echo "Retrospect Client for Linux started successfully!"
fi

if [ $UPGRADE ]; then
    echo "Upgrade completed successfully"
else
     if [ -d "/etc/${RCD}rc2.d" ] && [ ! -f "/etc/${RCD}rc2.d/S99retroclient" ]; then
         echo "Your system appears to be compatible with the startup system used "
         echo "by Red Hat, CentOS, and S.u.S.E. Would you like to create symbolic links "
         echo -n "to automatically start Retrospect Client for Linux? (y/n): "
         read X
         if [ "$X" = "y" ]; then
             for Y in 2 3 5; do
                ln -s $CLIENTDIR/rcl /etc/${RCD}rc$Y.d/S99retroclient
             done
             if [ -r '/etc/redhat-release' ]; then
                chkconfig --add rcl
             fi
         fi
     elif [ -f "/etc/rc.local" ]; then
        echo "Your system appears to be compatible with the startup system used "
        echo "by Ubuntu and Debian. Would you like to modify rc.local "
        echo -n "to automatically start Retrospect Client for Linux? (y/n): "
        read X
        if [ "$X" = "y" ]; then
            sed -i -e '$i /usr/local/retrospect/client/rcl start \n' /etc/rc.local
        fi
     elif [ ! -d "/etc/${RCD}rc2.d" ]; then
         echo "If your system uses an rc.local script, you should be able to start "
         echo "Retrospect Client for Linux automatically by adding the line "
         echo "'$CLIENTDIR/rcl start'. Otherwise, consult your system "
         echo "documentation for the best method."
     fi
fi
echo
exit 0
